/*! \file tlk_cert_def.h
**********************************************************************************
*Title:                         Discretix Certificate Handling Toolkit source file
*
* Filename:                     tlk_cert_def.h
*
* Project, Target, subsystem:   Certificate Handling Toolkit, OMA DRM
* 
* Created:                      02.04.2008
*
* Modified:                     02.04.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_CERT_GENERAL_DEF_H_
#define _TLK_CERT_GENERAL_DEF_H_


#ifdef __cplusplus
extern "C" {
#endif

#define TLK_CERT_SIZE_IN_BYTES_ALIGN(arg)	(((DxUint32_t)(arg))&0x3)
#define TLK_CERT_IS_BUFFER_WORD_ALIGN(arg)	(TLK_CERT_SIZE_IN_BYTES_ALIGN(arg) == 0)

    /* NULL validation macros*/
    /* Disable PCLINT Warning  506: Constant value Boolean */    
    /* Disable PCLINT Info Msg 774: Boolean within 'String' always evaluates to [True/False] */    
    #define TLK_CERT_IS_NULL_PARAM(param1)  /*lint -save -e506 -e774*/           \
            TLK_CERT_IS_NULL_4PARAMS((param1),(!DX_NULL),(!DX_NULL),(!DX_NULL))  \
            /*lint -restore */

    /* Takes 2 parameters and returns an ERROR if it is null.*/
    /* Disable PCLINT Warning  506: Constant value Boolean */    
    /* Disable PCLINT Info Msg 774: Boolean within 'String' always evaluates to [True/False] */    
    #define TLK_CERT_IS_NULL_2PARAMS(param1,param2) /*lint -save -e506 -e774*/   \
            TLK_CERT_IS_NULL_4PARAMS((param1),(param2),(!DX_NULL),(!DX_NULL))    \
            /*lint -restore */

    /* Takes 3 parameters and returns an ERROR if it is null.*/
    /* Disable PCLINT Warning  506: Constant value Boolean */    
    /* Disable PCLINT Info Msg 774: Boolean within 'String' always evaluates to [True/False] */    
    #define TLK_CERT_IS_NULL_3PARAMS(param1,param2,param3) /*lint -save -e506 -e774*/  \
            TLK_CERT_IS_NULL_4PARAMS((param1),(param2),(param3),(!DX_NULL))            \
            /*lint -restore */

    /* Takes 4 parameters and returns an ERROR if it is null.*/
    #define TLK_CERT_IS_NULL_4PARAMS(param1,param2,param3,param4)      \
           ((DX_NULL == ((void*)(param1)))||                           \
            (DX_NULL == ((void*)(param2)))||                           \
            (DX_NULL == ((void*)(param3)))||                           \
            (DX_NULL == ((void*)(param4))))



#define TLK_CERT_8TH_BIT_OFF                            (0x7F)
#define TLK_CERT_CONVERT_IN_WORDS(someValue)        DX_DIVIDE_ROUND_UP((someValue),(4))


#define TLK_CERT_WORD_ALLIGN(arg)                                                               \
                                 /*lint -save -e778*/                                           \
                                ((((DxUint32_t)(arg)) & (0x3)) ?                                \
                                (((((DxUint32_t)(arg))>>(2))+1)<<(2)) : ((DxUint32_t)(arg)))    \
                                /*lint -restore */


#define DX_1_WORD_PARAMS        (1)
#define DX_2_WORDS_PARAMS       (2)
#define DX_3_WORDS_PARAMS       (3)
#define DX_4_WORDS_PARAMS       (4)
#define DX_5_WORDS_PARAMS       (5)
#define DX_6_WORDS_PARAMS       (6)
#define DX_7_WORDS_PARAMS       (7)
#define DX_8_WORDS_PARAMS       (8)
#define DX_9_WORDS_PARAMS       (9)
#define DX_10_WORDS_PARAMS      (10)
#define DX_11_WORDS_PARAMS      (11)
#define DX_12_WORDS_PARAMS      (12)
#define DX_13_WORDS_PARAMS      (13)
#define DX_14_WORDS_PARAMS      (14)

#ifdef __cplusplus
}
#endif

#endif /*_TLK_CERT_GENERAL_DEF_H_*/
